package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.transformer;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.MicroformatsManager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 12:02 PM
 * To change this template use File | Settings | File Templates.
 */
public class DocumentProperties {

    private final String baseUrl;
    private final MicroformatsManager manager;
    private final String charset;
    private final List<MFException> errors = new LinkedList<MFException>();
    private final boolean expandTree;

    public DocumentProperties(final String baseUrl, final MicroformatsManager manager, final String charset, final boolean expandTree) {
        this.baseUrl = baseUrl;
        this.manager = manager;
        this.charset = charset;
        this.expandTree = expandTree;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public MicroformatsManager getManager() {
        return manager;
    }

    public String getCharset() {
        return charset;
    }

    public void putEx(final MFException e) {
        errors.add(e);
    }

    public List<MFException> getExs() {
        return Collections.unmodifiableList(errors);
    }

    public boolean isExpandTree() {
        return expandTree;
    }
}
