package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.transformer;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 2:29 PM
 * To change this template use File | Settings | File Templates.
 */
public class FinalContext implements Context<MicroformatData> {

    final List<MicroformatData> results;
    final DocumentProperties properties;

    public FinalContext(final List<MicroformatData> results, final DocumentProperties properties) {
        this.results = new LinkedList<MicroformatData>();
        this.results.addAll(results);
        this.properties = properties;
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.FINAL;
    }

    @Override
    public List<MicroformatData> getInfo() {
        return results;
    }

    @Override
    public Context<?> nextStep() {
        return this;
    }

    public List<MFException> getExs() {
        return properties.getExs();
    }
}
