package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.transformer;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.yandex.common.util.XmlUtils;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.functional.Filter;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 2:24 PM
 * To change this template use File | Settings | File Templates.
 */
public class LinkResolverContext implements Context<Document> {

    final LinkedList<Document> nodes;
    List<Document> result;
    final DocumentProperties documentProperties;

    public LinkResolverContext(final List<Document> nodes, final DocumentProperties documentProperties) {
        this.nodes = new LinkedList<Document>();
        for (final Document node : nodes) {
            this.nodes.add(node);
        }
        this.documentProperties = documentProperties;
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.AFTER_LINK_RESOLVE;
    }

    @Override
    public List<Document> getInfo() {
        if (result == null) {
            result = new LinkedList<Document>();
            for (final Document doc : nodes) {
                final List<Node> nodes = Tu.findByTagName(doc, "A");
                final List<Node> nodesIncl = Cu.filterAsList(nodes, new Filter<Node>() {
                    @Override
                    public boolean fits(final Node node) {
                        final Element anch = (Element) node;
                        return (Tu.containsAnyClass(anch.getAttribute("class"), Cf.list("include")));
                    }
                });
                for (final Node nd : nodesIncl) {
                    final Element anch = (Element) nd;
                    final String includeId = anch.getAttribute("href").substring(1);
                    final Element includeElement = searchById(includeId);
                    if (includeElement != null) {
                        if (!XmlUtils.isAinNonStrictSubtreeOfB(nd, includeElement)) {
                            final Node cl = doc.adoptNode(includeElement.cloneNode(true));
                            final Node parent = anch.getParentNode();
                            parent.replaceChild(cl, anch);
                        }
                    }
                }
                doc.normalize();
                result.add(doc);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    private Element searchById(final String id) {
        for (final Document el : nodes) {
            final Element subTree = Tu.findById(el.getFirstChild(), id);
            if (subTree != null) {
                return subTree;
            }
        }
        return null;
    }

    @Override
    public Context<?> nextStep() {
        return new LocatedParsingContext(getInfo(), documentProperties);
    }

//    @Override
//    public Context<?> nextStep() {
//        /*final LinkedList<String> stubRes = new LinkedList<String>();
//        for (DocumentFragment node : getInfo())
//        //stubRes.add(Tu.serializeDoc(node));
//        {
//            stubRes.add(Tu.extractHtmlContent(node) + "\n");
//        }
//        return new StubContext(stubRes);*/
//        /*for (final DocumentFragment df : getInfo()) {
//            System.out.println(Tu.serializeDoc(df));
//        }*/
//        return new ParseContext(getInfo(), documentProperties);
//    }
}
