package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.HReview;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 6/29/12
 * Time: 10:32 PM
 */
public class HReviewValidator implements MicroformatValidator {
    @Override
    public MFExceptions validate(final MicroformatData data) {
        final MFExceptions exs = new MFExceptions(data.getName());
        final Microformat spec = data.getSpec();
        if (spec == HReview.getInstance()) {
            MFAnyData item = data.getFirstOrNull("item");
            if (item!=null) {
               // if (item)
            }
        }
        try {
            for (final MFProperty prop : spec.getProperties()) {
                List<MFAnyData> values = data.getDataAsList(prop.getName());
                for (final MFAnyData value : values) {
                    if (value instanceof MicroformatData) {
                        exs.put(validate((MicroformatData) value));
                    }
                }
            }
            return exs;
        } catch (InvalidActionException e) {
            throw new RuntimeException(e);
        }
    }

}
