package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.NotOrgMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.HCard;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 6/29/12
 * Time: 10:27 PM
 */
public class OrgHCardValidator implements MicroformatValidator {
    @Override
    public MFExceptions validate(final MicroformatData data) {
        final MFExceptions exs = new MFExceptions(data.getName());
        if (data.getSpec() == HCard.getInstance()) {
            if (!HCard.getInstance().isOrganization(data)) {
                MFException ex = new NotOrgMFException("",false, data.getLocation());
                ex.setCard(data);
                exs.put(ex);
            }
        }
        return exs;
    }
}
