package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.PrefixMicroformatExceptionWrapper;

/**
 * Created by aleksart on 30.03.15.
 */
public class PrefixWrapperMFValidator implements MicroformatValidator {

    final MicroformatValidator validator;
    final String prefix;

    public PrefixWrapperMFValidator(MicroformatValidator validator, final String prefix) {
        this.validator = validator;
        this.prefix = prefix;
    }

    @Override
    public MFExceptions validate(final MicroformatData data) {
        MFExceptions exc = new MFExceptions(data.getName());
        for(MFException except :
                PrefixMicroformatExceptionWrapper.wrapAll((validator.validate(data)).getExceptionsByListView(), prefix)){
            exc.put(except);
        }
        return exc;
    }
}
