package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.YandexHProductMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances.HProduct;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 6/29/12
 * Time: 10:32 PM
 */
public class RootHProductValidator implements MicroformatValidator {
    @Override
    public MFExceptions validate(final MicroformatData data) {
        final MFExceptions exs = new MFExceptions(data.getName());
        if (data.getSpec() == HProduct.getInstance()) {
            final MFException ex = new YandexHProductMFException("",false, data.getLocation());
            ex.setCard(data);
            exs.put(ex);
        }
        return exs;
    }
}
