package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp;

import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.exception.OGPException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.transformer.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.data.OGPData;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;
import static ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.FrontEnd.cropString;
import static ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.FrontEnd.verifierNode;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/5/11
 * Time: 3:22 PM
 * To change this template use File | Settings | File Templates.
 */
public class OGPUtils {

    public static Xmler.Tag toXml(final OGPData data) {
        final List<Xmler.Tag> result = new LinkedList<Xmler.Tag>();
        for (final Pair<String, String> element : data.getAllData()) {
            result.add(verifierNode(element.first, null, false, tag("v", cropString(element.second))));
        }
        return verifierNode("og", data.hashCode(), true, result);
    }

    public static Pair<List<OGPData>, List<OGPException>> extractOGP(final String content, final String url) {
        final TransformStrategy transformStrategy = new TransformStrategy();
        final DocumentContext context = new DocumentContext(content, new DocumentProperties(url, null, "UTF-8"));
        final Context result = transformStrategy.processTillDone(context);
        if (result instanceof FinalContext) {
            final List<OGPData> results = ((FinalContext) result).getInfo();
            return new Pair<List<OGPData>, List<OGPException>>(results, ((FinalContext) result).exceptions);
        } else {
            return new Pair<List<OGPData>, List<OGPException>>(Collections.<OGPData>emptyList(),
                    Collections.<OGPException>emptyList());
        }
    }

    private static final HashMap<String, String> categories = new HashMap<String, String>();

    static {
        final String[][] initCategories =
                {{"company", null}, {"organization", null}, {"band", "184105908"}, {"goverment", "184105716"},
                        {"non_profit", null}, {"school", "184106240"}, {"university", "184106236"}};
        for (final String[] row : initCategories) {
            categories.put(row[0], row[1]);
        }
    }

    public static boolean isOrg(final String type) {
        return categories.containsKey(type);
    }

    public static String getCat(final String type) {
        return categories.get(type);
    }
}
