package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.exception;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.data.OGPData;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 2/26/12
 * Time: 8:48 AM
 */
public class EmptyFieldsValidator implements OGPValidator {

    private final List<String> fields;

    public EmptyFieldsValidator(final List<String> fields) {
        this.fields = fields;
    }

    @Override
    public List<OGPException> validate(final OGPData data) {
        final List<OGPException> exceptions = new LinkedList<OGPException>();
        final List<String> missingFields = new LinkedList<String>();
        for (final String field : fields) {
            if (!data.containsProp(field))
                missingFields.add("og:"+field);
        }
        if (!missingFields.isEmpty()) {
            StringBuilder resultBuilder = new StringBuilder();
            for (final String field : missingFields)
                if (resultBuilder.length()==0)
                    resultBuilder.append(field);
                else
                    resultBuilder.append(", ").append(field);
            exceptions.add(new EmptyFieldException(resultBuilder.toString(),data,false));
        }
        return exceptions;
    }
}
