package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.exception;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.VerifierException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.data.OGPData;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 2/26/12
 * Time: 8:20 AM
 */
public abstract class OGPException extends VerifierException {

    public final String message;
    public final OGPData card;
    public final boolean isCritical;

    public OGPException(final String message, final OGPData card, final boolean critical) {
        this.message = message;
        this.card = card;
        isCritical = critical;
    }

    @Override
    public boolean getSeverity() {
        return isCritical;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public int getHash() {
        return card.hashCode();
    }
}
