package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.exception;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker.LanguageContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 14.09.12
 * Time: 18:29
 */
public class OGPExceptionSerializerFactory {

    private static Map<LanguageContext, OGPExceptionSerializer> serializerMap =
            new ConcurrentHashMap<LanguageContext, OGPExceptionSerializer>();

    public OGPExceptionSerializer createSerializer(final LanguageContext context) {
        if (serializerMap.containsKey(context)) {
            return serializerMap.get(context);
        } else {
            final OGPExceptionSerializer serializer = new TankerOGPExceptionSerializer(context);
            serializerMap.put(context, serializer);
            return serializer;
        }
    }

}
