package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.transformer;

import ru.yandex.common.util.collections.CollectionFactory;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 3:10 PM
 * To change this template use File | Settings | File Templates.
 */
public class DocumentContext implements Context<String> {

    final String document;
    final DocumentProperties documentProperties;
    private static final int TAG_LIMIT = 100000;

    public DocumentContext(final String document, final DocumentProperties documentProperties) {
        this.document = document;
        this.documentProperties = documentProperties;
        checkDocumentSize();
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.DOCUMENT;
    }

    @Override
    public List<String> getInfo() {
        return CollectionFactory.list(document);
    }

    @Override
    public Context<?> nextStep() {
        return new AllContext(CollectionFactory.list(document), documentProperties);
        //return new StubContext(document);  //To change body of implemented methods use File | Settings | File Templates.
    }

    /**
     * It is a simplified check: '<' in the document may be not opening tag.
     * But it is simple and will do in most cases. I cannot believe that
     * that we can have tens of thousands '<', which do not open tags.
     */
    private void checkDocumentSize() {
        int tagCount = 0;
        for (int i=0; i<document.length(); i++) {
            if ('<' == document.charAt(i) && (++tagCount > TAG_LIMIT)) {
                throw new IllegalArgumentException("Document is too complex, tag limit exceeded");
            }
        }
    }

}
