package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.transformer;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.data.OGPData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.exception.OGPException;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 2:29 PM
 * To change this template use File | Settings | File Templates.
 */
public class FinalContext implements Context<OGPData> {

    final public List<OGPData> results;
    final public List<OGPException> exceptions;

    public FinalContext(final List<OGPData> results, final List<OGPException> exceptions) {
        this.results = Collections.unmodifiableList(new LinkedList<OGPData>(results));
        this.exceptions = Collections.unmodifiableList(new LinkedList<OGPException>(exceptions));
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.FINAL;
    }

    @Override
    public List<OGPData> getInfo() {
        return results;
    }

    @Override
    public Context<?> nextStep() {
        return this;
    }
}
