package ru.yandex.webmaster3.core.semantic.semantic_document_parser.ogp.transformer;

import ru.yandex.common.util.collections.CollectionFactory;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 7/15/11
 * Time: 3:06 PM
 * To change this template use File | Settings | File Templates.
 */
public class StubContext implements Context<String> {

    final List<String> message;

    public StubContext(final String... message) {
        this.message = CollectionFactory.list(message);
    }

    public StubContext(final List<String> message) {
        this.message = new LinkedList<String>();
        this.message.addAll(message);
    }

    @Override
    public TransformationStep getStep() {
        return TransformationStep.FINAL;
    }

    @Override
    public List<String> getInfo() {
        return message;
    }

    @Override
    public Context<?> nextStep() {
        return this;  //To change body of implemented methods use File | Settings | File Templates.
    }
}
