package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data;

import ru.yandex.common.util.Su;
import ru.yandex.common.util.json.Jsoner;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

import static ru.yandex.common.util.json.Jsoner.arrayOfSimples;
import static ru.yandex.common.util.json.Jsoner.object;
import static ru.yandex.common.util.json.Jsoner.pair;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 26.07.12
 * Time: 17:23
 */
public class RDFaComplexProperty extends RDFaProperty {

    public final RDFaEntity entity;

    public RDFaComplexProperty(final String propId, final RDFaEntity entity) {
        super(propId);
        this.entity = entity;
        if(null!=entity && !entity.getLocation().equals(EntityLocation.DEFAULT_LOCATION)) {
            super.setLocation(entity.getLocation());
        }
    }

    public RDFaComplexProperty(final String propId, final RDFaEntity entity, final EntityLocation location) {
        super(propId);
        this.entity = entity;
        this.entity.setLocation(location);
        super.setLocation(location);
    }

    @Override
    public String debugString() {
        return entity.debugString();
    }

    @Override
    public Jsoner.JsonObject asJson() {
        if (entity == null) {
            return object();
        }
        if (entity.id != null) {
            return object(pair("resource", entity.id), pair("type", arrayOfSimples(Su.split(entity.type))));
        }
        return entity.asJson();
    }
}
