package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data;

import ru.yandex.common.util.Su;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.collections.MultiMap;
import ru.yandex.common.util.functional.Filter;
import ru.yandex.common.util.json.JsonConvertable;
import ru.yandex.common.util.json.JsonConvertableWithKey;
import ru.yandex.common.util.json.Jsonable;
import ru.yandex.common.util.json.Jsoner;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

import static ru.yandex.common.util.json.Jsoner.*;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 26.07.12
 * Time: 17:08
 */
public class RDFaEntity implements JsonConvertable, Jsonable {

    public String getTagName() {
        return "rdfanode";
    }

    public String getResourceTag() {
        return "resource";
    }

    public String getTypeTag() {
        return "type";
    }

    private static final int RDFA_START = 1000001;
    private final static AtomicInteger TOTAL_COUNTER = new AtomicInteger(RDFA_START);

    public final int count = TOTAL_COUNTER.incrementAndGet();
    public String type;
    public final String id;
    public boolean isRoot = false;
    private MultiMap<String, RDFaProperty> propertyMap = new MultiMap<String, RDFaProperty>(true);
    private List<RDFaProperty> propertyList = new LinkedList<RDFaProperty>();
    private boolean isIdFromUrl = false;
    int line;
    int column;



    private EntityLocation location;

    public void setLocation(EntityLocation location) {
        this.location = location;
    }

    public EntityLocation getLocation() {
        return location;
    }

    public RDFaEntity(final String type, final String id) {
        this.type = type==null?"":type;
        this.id = id;
        this.location = EntityLocation.DEFAULT_LOCATION;
    }

    public RDFaEntity(final String type, final String id, final EntityLocation location) {
        this.type = type==null?"":type;
        this.id = id;
        this.location = location;
    }

    public void setType(String type){
        this.type = type;
    }

    public void addProperty(final RDFaProperty property) {
        propertyMap.put(property.propId, Cf.list(property));
        propertyList.add(property);
    }

    public void appendProperty(final RDFaProperty property) {
        propertyMap.append(property.propId, property);
        propertyList.add(property);
    }

    public void addProperties(final List<RDFaProperty> properties) {
        for (final RDFaProperty property : properties) {
            addProperty(property);
        }
    }

    public void appendProperties(final List<RDFaProperty> properties) {
        for (final RDFaProperty property : properties) {
            appendProperty(property);
        }
    }

    public List<RDFaProperty> getProperty(final String key) {
        return propertyMap.containsKey(key) ? propertyMap.get(key) : Collections.<RDFaProperty>emptyList();
    }

    public List<RDFaProperty> getProperty(List<String> keys) {
        ArrayList<RDFaProperty> res = new ArrayList<RDFaProperty>();
        for(String key: keys) {
            res.addAll(propertyMap.containsKey(key) ? propertyMap.get(key) : Collections.<RDFaProperty>emptyList());
        }
        return res;
    }

    public RDFaProperty getFirstOrNull(final String key) {
        return hasProperty(key) ? getProperty(key).get(0) : null;
    }

    public Set<String> getPropertyList() {
        return propertyMap.keySet();
    }

    public boolean hasProperty(final String key) {
        return propertyMap.containsKey(key);
    }


    public List<RDFaProperty> getValuePairs() {
        return propertyList;
    }


    public String debugString() {
        StringBuilder result =
                new StringBuilder().append("resource: ").append(id).append(" type: ").append(type).append(" {\n");
        for (final String prop : getPropertyList()) {
            result.append(prop).append(" = [");
            for (final RDFaProperty val : getProperty(prop)) {
                result.append(val.debugString()).append(",\n");
            }
            result.append("]\n");
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public void toJson(final StringBuilder storage) {
        asJson().toJson(storage);
    }

    @Override
    public Jsoner.JsonObject asJson() {
        final List<JsonConvertableWithKey> result = new LinkedList<JsonConvertableWithKey>();
        if (!Su.isEmpty(id)) {
            result.add(pair("@resource", id));
        }
        if (!Su.isEmpty(type)) {
            result.add(pair("@type", Jsoner.arrayOfSimples(Su.split(this.type))));
        }
        for (final String prop : getPropertyList()) {
            result.add(pair(prop, arrayOfJsonables(getProperty(prop))));
        }
        return object(result);
    }

    public boolean isEmpty() {
        return propertyMap.isEmpty();
    }


    public void filterEntity(final Filter<RDFaProperty> filter) {
        propertyList = Cu.filterAsList(propertyList, filter);
        propertyMap = propertyMap.filterR(filter);
    }

    public boolean isIdFromUrl() {
        return isIdFromUrl;
    }

    public void setIdFromUrl(boolean isIdFromUrl) {
        this.isIdFromUrl = isIdFromUrl;
    }
}
