package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data;

import ru.yandex.common.util.json.JsonConvertable;
import ru.yandex.common.util.json.Jsonable;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 26.07.12
 * Time: 17:23
 */
public abstract class RDFaProperty implements JsonConvertable,Jsonable {


    public final String propId;

    private EntityLocation location = EntityLocation.DEFAULT_LOCATION;

    public RDFaProperty(final String propId) {
        this.propId = propId;
    }

    public abstract String debugString();

    @Override
    public void toJson(final StringBuilder storage) {
        asJson().toJson(storage);
    }

    public void setLocation(EntityLocation location){
        this.location = location;
    }

    public EntityLocation getLocation() {
        return location;
    }
}
