package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data;

import ru.yandex.common.util.json.JsonConvertableWithKey;
import ru.yandex.common.util.json.Jsoner;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.json.Jsoner.object;
import static ru.yandex.common.util.json.Jsoner.pair;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 26.07.12
 * Time: 17:20
 */
public class RDFaValueProperty extends RDFaProperty {

    public final String textValue;
    public final String hrefValue;
    public final String htmlValue;
    public boolean metaTag = false;
    public RDFaValueProperty(final String propId, final String textValue, final String hrefValue, final String htmlValue) {
        super(propId);
        this.textValue = textValue == null ? null : textValue.trim();
        this.hrefValue = hrefValue == null ? null : hrefValue.trim();
        this.htmlValue = htmlValue == null ? null : htmlValue.trim();
    }

    public RDFaValueProperty(final String propId, final String textValue, final String hrefValue, final String htmlValue, final EntityLocation location) {
        super(propId);
        this.textValue = textValue == null ? null : textValue.trim();
        this.hrefValue = hrefValue == null ? null : hrefValue.trim();
        this.htmlValue = htmlValue == null ? null : htmlValue.trim();
        super.setLocation(location);
    }

    @Override
    public String debugString() {
        return "{" + textValue + "," + hrefValue + "," + htmlValue + "}";
    }

    @Override
    public Jsoner.JsonObject asJson() {
        final List<JsonConvertableWithKey> result = new LinkedList<JsonConvertableWithKey>();
        if (textValue != null) {
            result.add(pair("text", textValue));
        }
        if (hrefValue != null) {
            result.add(pair("href", hrefValue));
        }
/*        if (!isEmpty(htmlValue)) {
            result.add(pair("html", htmlValue));
        }*/
        return object(result);
    }

    public String getValue() {
        if (hrefValue!=null)
            return hrefValue;
        return textValue;
    }
    public void metaTag(boolean metaTag){
        this.metaTag = metaTag;
    }
}
