package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.VerifierException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12.09.12
 * Time: 20:03
 */
public abstract class RDFaException extends VerifierException {

    public final boolean isCritical;
    public final RDFaEntity card;
    public final String message;

    public final EntityLocation location;

    public RDFaException(final boolean critical, final RDFaEntity card, final String message) {
        this.isCritical = critical;
        this.card = card;
        this.message = message;
        this.location = card.getLocation();
    }

    public RDFaException(final boolean critical, final RDFaEntity card, final String message, final EntityLocation location) {
        this.isCritical = critical;
        this.card = card;
        this.message = message;
        this.location = location;
    }


    @Override
    public boolean getSeverity() {
        return isCritical;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public int getHash() {
        if (card == null) {
            return 0;
        }
        return card.count;
    }
    @Override
    public int hashCode(){
        return getHash()*message.length() + message.hashCode();
    }
    @Override
    public boolean equals(Object o){
        if(o instanceof RDFaException) {
            RDFaException e = (RDFaException) o;
            return e.getHash() == this.getHash() && message.equals(e.getMessage());
        }
        return false;
    }

    @Override
     public String getLocation(){

        return location.toString();
    }


}
