package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

/**
 * Created with IntelliJ IDEA.
 * User: aleksart
 * Date: 22.11.13
 * Time: 19:35
 * To change this template use File | Settings | File Templates.
 */
public class SchemaMisspellRDFaValidatorException extends RDFaException {

    final String key;

    public SchemaMisspellRDFaValidatorException(final String type, final boolean isCritical, final RDFaEntity data, final String message) {
        super(isCritical, data, message);
        this.key = "sorg_misspell_" + type;
    }

    public SchemaMisspellRDFaValidatorException(final String type, final boolean isCritical, final RDFaEntity data, final String message, final EntityLocation location) {
        super(isCritical, data, message,location);
        this.key = "sorg_misspell_" + type;
    }

    @Override
    public String getKey() {
        return key;
    }
}
