package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;

/**
 * Created with IntelliJ IDEA.
 * User: aleksart
 * Date: 25.11.13
 * Time: 17:15
 * To change this template use File | Settings | File Templates.
 */
public class SchemaTypeRDFaValidatorException extends RDFaException {
    String key;

    public SchemaTypeRDFaValidatorException(String type, boolean isCritical, RDFaEntity data, String message) {
        super(isCritical, data, message);
        this.key = "sorg_format_" + type;
    }

    public SchemaTypeRDFaValidatorException(String type, boolean isCritical, RDFaEntity data, String message, final EntityLocation location) {
        super(isCritical, data, message, location);
        this.key = "sorg_format_" + type;
    }

    @Override
    public String getKey() {
        return key;
    }
}
