package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.jsonld;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaProperty;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 02.06.14
 * Time: 0:21
 * Context manager created on top of another context manager
 */
public class ClearableContextManager extends ContextManager {

    private final ContextManager baseManager;

    public ClearableContextManager(final ContextManager baseManager) throws IOException {
        super(Collections.<String, String>emptyMap());
        this.baseManager = baseManager;
    }

    @Override
    public List<RDFaProperty> getContext(final String uri) {
        List<RDFaProperty> result = super.getContext(uri);
        if (result == null) {
            return baseManager.getContext(uri);
        } else {
            return result;
        }
    }

    public void clear() {
        contextMap.clear();
    }
}
