package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.jsonld;

import java.util.HashMap;
import java.util.Map;

/**
* Created by IntelliJ IDEA.
* User: rasifiel
* Date: 18.02.14
* Time: 1:33
*/
public class Context {
    String baseUri;
    String vocabMapping;
    final Map<String, TermDefinition> definitionMap = new HashMap<String, TermDefinition>();
    public String defaultLanguage;

    public Context(final String baseUri, final String vocabMapping) {
        this.baseUri = baseUri;
        this.vocabMapping = vocabMapping;
    }

    public Context(final Context base) {
        definitionMap.putAll(base.definitionMap);
        baseUri = base.baseUri;
        vocabMapping = base.vocabMapping;
    }

    public void addDefinition(final String term, final TermDefinition def) {
        definitionMap.put(term, def);
    }

    public boolean containsTerm(final String term) {
        return definitionMap.containsKey(term);
    }

    public TermDefinition getDefinition(final String term) {
        return definitionMap.get(term);
    }

    public void removeDefinition(final String term) {
        definitionMap.remove(term);
    }

}
