package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.jsonld;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.JsonExpansionRDFaException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.RDFaException;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 22.04.14
 * Time: 17:52
 */
public class JSONLDExpansionException extends RuntimeException {

    private EntityLocation location = EntityLocation.DEFAULT_LOCATION;

    public JSONLDExpansionException(final String message) {
        super(message);
    }

    public JSONLDExpansionException(final String message, final EntityLocation location) {
        super(message);
        this.location = location;
    }

    public RDFaException getRDFaException(RDFaEntity entity) {
        if(location.equals(EntityLocation.DEFAULT_LOCATION)){
            location = entity.getLocation();
        }
        return new JsonExpansionRDFaException(true,entity,this.getMessage(),location);
    }
}
