package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.jsonld;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.FrontEnd;

import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 02.06.14
 * Time: 14:47
 */
public class JSONLDParserFactory {

    private ContextManager basicContextManager;

    public void setBasicContextManager(final ContextManager basicContextManager) {
        this.basicContextManager = basicContextManager;
    }

    private FrontEnd frontEnd;

    public void setFrontEnd(final FrontEnd frontEnd) {
        this.frontEnd = frontEnd;
    }

    private boolean loadRemoteContext;

    public void setLoadRemoteContext(boolean loadRemoteContext) {
        this.loadRemoteContext = loadRemoteContext;
    }

    public JSONLDParser createParser() {
        JSONLDParser parser = new JSONLDParser();
        try {
            parser.setContextManager(new ClearableContextManager(basicContextManager));
            parser.setLoadRemoteContext(loadRemoteContext);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        parser.setFrontEnd(frontEnd);
        return parser;
    }
}
