package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.transformers;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.functional.Function;

import java.util.Collections;
import java.util.List;

import static ru.yandex.common.util.collections.CollectionFactory.pair;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 15.08.12
 * Time: 14:50
 */
public class DefaultPrefixProvider {

    public static final DefaultPrefixProvider instance;

    static {
        final List<Pair<String, String>> list = Cf.list(pair("grddl", "http://www.w3.org/2003/g/data-view#"),
                pair("ma", "http://www.w3.org/ns/ma-ont#"), pair("owl", "http://www.w3.org/2002/07/owl#"),
                pair("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"), pair("rdfa", "http://www.w3.org/ns/rdfa#"),
                pair("rdfs", "http://www.w3.org/2000/01/rdf-schema#"), pair("rif", "http://www.w3.org/2007/rif#"),
                pair("skos", "http://www.w3.org/2004/02/skos/core#"),
                pair("skosxl", "http://www.w3.org/2008/05/skos-xl#"), pair("wdr", "http://www.w3.org/2007/05/powder#"),
                pair("void", "http://rdfs.org/ns/void#"), pair("wdrs", "http://www.w3.org/2007/05/powder-s#"),
                pair("xhv", "http://www.w3.org/1999/xhtml/vocab#"), pair("xml", "http://www.w3.org/XML/1998/namespace"),
                pair("xsd", "http://www.w3.org/2001/XMLSchema#"), pair("cc", "http://creativecommons.org/ns#"),
                pair("ctag", "http://commontag.org/ns#"), pair("dc", "http://purl.org/dc/terms/"),
                pair("dcterms", "http://purl.org/dc/terms/"), pair("foaf", "http://xmlns.com/foaf/0.1/"),
                pair("gr", "http://purl.org/goodrelations/v1#"),
                pair("ical", " http://www.w3.org/2002/12/cal/icaltzd#"), pair("og", "http://ogp.me/ns#"),
                pair("rev", "http://purl.org/stuff/rev#"), pair("sioc", "http://rdfs.org/sioc/ns#"),
                pair("v", "http://rdf.data-vocabulary.org/#"), pair("vcard", "http://www.w3.org/2006/vcard/ns#"),
                pair("schema", "http://schema.org/"),pair("ya","http://webmaster.yandex.ru/vocabularies/"),
                pair("twitter","http://dev.twitter.com/cards/markup"),pair("vk","http://vk.com/dev/share_details"),
                pair("fb","http://ogp.me/ns/fb#"),
                pair("bibo","http://purl.org/ontology/bibo/"),pair("dbp","http://dbpedia.org/property/"),
                pair("dbp-owl","http://dbpedia.org/ontology/"),pair("dbr","http://dbpedia.org/resource/"),
                pair("ex","http://example.org/"));

        instance = new DefaultPrefixProvider(list);
    }

    private final List<ExperimentalExtractor.Prefix2URI> prefixList;

    private DefaultPrefixProvider(final List<Pair<String, String>> prefixList) {
        this.prefixList =
                Collections.unmodifiableList(new Function<Pair<String, String>, ExperimentalExtractor.Prefix2URI>() {

                    @Override
                    public ExperimentalExtractor.Prefix2URI apply(final Pair<String, String> arg) {
                        return new ExperimentalExtractor.Prefix2URI(arg.first, arg.second);
                    }
                }.map(prefixList));
    }

    public List<ExperimentalExtractor.Prefix2URI> getPrefixList() {
        return prefixList;
    }
}
