package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.transformers;

/**
 * Created by aleksart on 19.05.15.
 */
public class OpenGraphNamespace
{
    private final String prefix;
    private final String schemaURI;

    public String getNamespaceGroup() {
        return namespaceGroup;
    }


    private final String namespaceGroup;

    /**
     * Construct a namespace
     * @param prefix The OpenGraph assigned namespace prefix such as og or og_appname
     * @param schemaURI The URL for the OpenGraph schema
     */
    public OpenGraphNamespace(String prefix, String schemaURI, String namespaceGroup)
    {
        this.prefix = prefix;
        this.schemaURI = schemaURI;
        this.namespaceGroup = namespaceGroup;
    }

    /*
     * Fetch the prefix used for the namespace
     */
    public String getPrefix()
    {
        return prefix;
    }

    /*
     * Fetch the address for the schema reference
     */
    public String getSchemaURI()
    {
        return schemaURI;
    }
}