package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.validator;

import ru.yandex.webmaster3.core.semantic.schema_org_information_extractor.SchemaField;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.JSONLDEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaComplexProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.RDFaException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 28.10.14
 * Time: 18:43
 */
public class JSONLDTypeRDFaValidator implements RDFaValidator {
    @Override
    public List<RDFaException> validate(final RDFaEntity data) {
        if (!(data instanceof JSONLDEntity)) {
            return Collections.emptyList();
        }
        final List<RDFaException> exceptions = new ArrayList<RDFaException>();
        for (RDFaProperty prop : data.getValuePairs()) {
            if (prop instanceof RDFaComplexProperty) {
                if (SchemaValidator.isJSONLDValueProp(prop)) {
                    SchemaValidator.validateJSONLDSimpeData(data, exceptions, (RDFaComplexProperty) prop, prop.propId,
                            Collections.<SchemaField>emptyList());
                } else {
                    exceptions.addAll(validate(((RDFaComplexProperty) prop).entity));
                }
            }
        }
        return exceptions;
    }
}
