package ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.validator;

import ru.yandex.common.util.Su;
import ru.yandex.webmaster3.core.semantic.schema_org_information_extractor.SchemaClass;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaEntity;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.data.RDFaProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.NoSuchSchemaClassRDFaValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.NoSuchSchemaFieldRDFaValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.rdfa.exceptions.RDFaException;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import static ru.yandex.common.util.StringUtils.isEmpty;

/**
 * Created by aleksart on 03.03.14.
 */
public class NameSpaceValidator implements RDFaValidator {

    Map<String, SchemaClass> classMap;
    String prefix;

    public NameSpaceValidator(Map<String, SchemaClass> classMap, String prefix){
        this.classMap = classMap;
        this.prefix = prefix;
    }

    @Override
    public List<RDFaException> validate(RDFaEntity data) {

        List<RDFaException> exceptions = new LinkedList<RDFaException>();
        final List<String> allTypes = Su.split(data.type);
        for(String type : allTypes){
            if(!isEmpty(type)){
                if(type.startsWith(prefix)){
                    if(!classMap.containsKey(type)){
                        exceptions.add(new NoSuchSchemaClassRDFaValidatorException(false, data, type + "$$" + prefix));
                    }
                }
            }
        }
        allTypes.add(prefix);
        boolean foundProp = false;
        for(RDFaProperty property: data.getValuePairs()){
            String propertyName = property.propId;
            if(propertyName.startsWith(prefix)){
                for(String type : allTypes){
                    if(classMap.containsKey(type)){
                        SchemaClass schemaClass = classMap.get(type);
                        if(schemaClass.fields.containsKey(propertyName)){
                            foundProp = true;
                        }
                    }
                }
                if(!foundProp){
                    exceptions.add(new NoSuchSchemaFieldRDFaValidatorException(false,data, propertyName + "$$" + prefix, property.getLocation()));
                }
            }

        }

        return exceptions;
    }
}
