package ru.yandex.webmaster3.core.semantic.semantic_document_parser.serialize.util;

import org.json.*;

/**
 * Created by aleksart on 22.09.15.
 */
public enum APIVersion {
    VERSION_0_1("v0.0", 0),
    VERSION_1_0("v1.0", 1),
    VERSION_1_1("v1.1", 2);

    private final String stringVersion;

    private final int incVersion;

    APIVersion(String stringVersion, int incVersion) {
        this.stringVersion = stringVersion;
        this.incVersion = incVersion;
    }

    public String getStringVersion() {
        return stringVersion;
    }

    public int getIncVersion() {
        return incVersion;
    }


    public static JSONObject serializeToArrayForOldVersion(APIVersion version, JSONObject e) throws JSONException {
        switch (version) {
            case VERSION_0_1:
            case VERSION_1_0:
                e.put("location", new JSONArray().put(e.getString("#location")));
                e.put("message", new JSONArray().put(e.getString("#message")));
                e.put("error_code", new JSONArray().put(e.getString("#error_code")));
                e.put("type", new JSONArray().put(e.getString("#type")));
                e.remove("#type");
                e.remove("#error_code");
                e.remove("#message");
                e.remove("#location");
                break;
        }
        return e;
    }

    public static String getErrorKey(APIVersion version) {
        return getKey(version, "error");
    }

    public static String getResourceKey(APIVersion version) {
        return getKey(version, "resource");
    }

    public static String getKey(APIVersion version, String key) {
        switch (version) {
            case VERSION_0_1:
            case VERSION_1_0:
                return "@" + key;
            case VERSION_1_1:
            default:
                return "#" + key;
        }
    }

    @Override
    public String toString() {
        return "version: " + stringVersion;
    }

}
