package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.TextMicrodata;

import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * @author Dmitry Batkovich <daddy-bear@yandex-team.ru>
 */
public abstract class AbstractStructData extends XmlStructData {

    @Nullable
    private final String lang;

    @Nullable
    private final String sourceUrl;

    protected AbstractStructData(final @Nullable String sourceUrl, final @Nullable String lang) {
        this.lang = lang;
        this.sourceUrl = sourceUrl;
    }

    @Nullable
    public String getLang() {
        return lang;
    }

    @Nullable
    public String getSourceUrl() {
        return sourceUrl;
    }

    @Nullable
    protected Xmler.Tag getLangTag() {
        return lang == null ? null : tag("zora-lang", lang);
    }

    protected Xmler.Tag getSourceUrlTag() {
        return tag("source-url", sourceUrl);
    }

    protected static void append(final List<Xmler.Tag> tags, final @NotNull Xmler.Tag tag) {
        tags.add(tag);
    }

    protected static void appendIfNotNull(final List<Xmler.Tag> tags, final @Nullable Xmler.Tag tag) {
        if (tag != null) {
            tags.add(tag);
        }
    }

    protected static void appendIfNotNull(final List<Xmler.Tag> tags, final String tagName, final @Nullable String tagValue) {
        if (tagValue != null) {
            tags.add(tag(tagName, tagValue));
        }
    }

    protected static void appendIfNotNull(final List<Xmler.Tag> tags, final String tagName, final @Nullable TextMicrodata textMicrodata) {
        if (textMicrodata != null) {
            tags.add(textMicrodata.toXml(tagName));
        }
    }
}
