package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Pair;

import java.util.ArrayList;
import java.util.List;

public class AccordsBuilder {
    private String title;
    private String artistName;
    private List<Pair<String, String>> chordsAndTextLines = new ArrayList<Pair<String, String>>();
    private String raw;
    private String lang;
    private String sourceUrl;

    public AccordsBuilder setTitle(final String title) {
        this.title = title;
        return this;
    }

    public AccordsBuilder setArtistName(final String artistName) {
        this.artistName = artistName;
        return this;
    }

    public AccordsBuilder addChordsAndTextLines(final Pair<String, String> chordsAndTextLines) {
        this.chordsAndTextLines.add(chordsAndTextLines);
        return this;
    }

    public AccordsBuilder setRaw(final String raw) {
        this.raw = raw;
        return this;
    }

    public AccordsBuilder setLang(final String lang) {
        this.lang = lang;
        return this;
    }

    public AccordsBuilder setSourceUrl(final String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    public Chords createAccords() {
        return new Chords(title, artistName, chordsAndTextLines, raw, sourceUrl, lang);
    }
}