package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/8/11
 * Time: 5:02 PM
 * To change this template use File | Settings | File Templates.
 */
public class Address {


    private final String onlyString;
    private final String country;
    private final String locality;
    private final String region;
    private final String postalCode;
    private final String street;
    private final String extended;
    private final String pobox;

    public Address(final String country, final String locality, final String region, final String postalCode, final String street, final String extended, final String pobox) {
        this.onlyString = null;

        this.country = country;
        this.locality = locality;
        this.region = region;
        this.postalCode = postalCode;
        this.street = street;
        this.extended = extended;
        this.pobox = pobox;
    }

    public Address(final String onlyString) {
        this.onlyString = onlyString;

        this.country = null;
        this.locality = null;
        this.region = null;
        this.postalCode = null;
        this.street = null;
        this.extended = null;
        this.pobox = null;
    }

    public String getCountry() {
        return country;
    }

    public String getLocality() {
        return locality;
    }

    public String getRegion() {
        return region;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public String getStreet() {
        return street;
    }

    public String getExtended() {
        return extended;
    }

    public String getOnlyString() {
        return onlyString;
    }

    public String getPobox() {
        return pobox;
    }

    public Xmler.Tag toXml() {
        if (onlyString != null) {
            return tag("address", attribute("fullText", onlyString));
        }
        final StringBuilder sb = new StringBuilder();
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (country != null) {
            sb.append(country).append(" ");
            tags.add(tag("country-name", country));
        }
        if (region != null) {
            sb.append(region).append(" ");
            tags.add(tag("region", region));
        }
        if (locality != null) {
            sb.append(locality).append(" ");
            tags.add(tag("locality", locality));
        }
        if (street != null) {
            sb.append(street).append(" ");
            tags.add(tag("street-address", street));
        }
        if (extended != null) {
            sb.append(extended).append(" ");
            tags.add(tag("extended-address", extended));
        }
        if (postalCode != null) {
            sb.append(postalCode).append(" ");
            tags.add(tag("postal-code", postalCode));
        }
        if (pobox != null) {
            sb.append(pobox).append(" ");
            tags.add(tag("post-office-box", pobox));
        }
        return tag("address", attribute("fullText", sb.toString().trim()), tags);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Address address = (Address) o;

        if (country != null ? !country.equals(address.country) : address.country != null) {
            return false;
        }
        if (extended != null ? !extended.equals(address.extended) : address.extended != null) {
            return false;
        }
        if (onlyString != null ? !onlyString.equals(address.onlyString) : address.onlyString != null) {
            return false;
        }
        if (locality != null ? !locality.equals(address.locality) : address.locality != null) {
            return false;
        }
        if (pobox != null ? !pobox.equals(address.pobox) : address.pobox != null) {
            return false;
        }
        if (postalCode != null ? !postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (region != null ? !region.equals(address.region) : address.region != null) {
            return false;
        }
        return !(street != null ? !street.equals(address.street) : address.street != null);

    }

    @Override
    public int hashCode() {
        int result = onlyString != null ? onlyString.hashCode() : 0;
        result = 31 * result + (country != null ? country.hashCode() : 0);
        result = 31 * result + (locality != null ? locality.hashCode() : 0);
        result = 31 * result + (region != null ? region.hashCode() : 0);
        result = 31 * result + (postalCode != null ? postalCode.hashCode() : 0);
        result = 31 * result + (street != null ? street.hashCode() : 0);
        result = 31 * result + (extended != null ? extended.hashCode() : 0);
        result = 31 * result + (pobox != null ? pobox.hashCode() : 0);
        return result;
    }
}

