package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 5/28/12
 * Time: 4:54 PM
 */
public class AggregateRating extends XmlStructData {

    public final String bestRating;
    public final String ratingValue;
    public final String worstRating;
    public final String ratingCount;
    public final String reviewCount;
    public final String sourceUrl;

    public AggregateRating(final String bestRating, final String ratingValue, final String worstRating, final String ratingCount, final String reviewCount, final String sourceUrl) {
        this.bestRating = bestRating;
        this.ratingValue = ratingValue;
        this.worstRating = worstRating;
        this.ratingCount = ratingCount;
        this.reviewCount = reviewCount;
        this.sourceUrl = sourceUrl;
    }

    private Set<String> TAGS = Collections.unmodifiableSet(Cf.set("address"));

    @Override
    public Set<String> getEntityTags() {
        return TAGS;
    }

    public Xmler.Tag toXml() {
        final LinkedList<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (bestRating!=null)
            tags.add(tag("best-rating",bestRating));
        if (ratingValue!=null)
            tags.add(tag("rating-value",ratingValue));
        if (worstRating!=null)
            tags.add(tag("worst-rating",worstRating));
        if (ratingCount!=null)
            tags.add(tag("rating-count",ratingCount));
        if (reviewCount!=null)
            tags.add(tag("review-count",reviewCount));
        if (sourceUrl!=null)
            tags.add(tag("source-url",sourceUrl));
        return tag("aggregate-rating",attribute("type-id",24),tags);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final AggregateRating that = (AggregateRating) o;

        if (bestRating != null ? !bestRating.equals(that.bestRating) : that.bestRating != null) {
            return false;
        }
        if (ratingCount != null ? !ratingCount.equals(that.ratingCount) : that.ratingCount != null) {
            return false;
        }
        if (ratingValue != null ? !ratingValue.equals(that.ratingValue) : that.ratingValue != null) {
            return false;
        }
        if (reviewCount != null ? !reviewCount.equals(that.reviewCount) : that.reviewCount != null) {
            return false;
        }
        return !(worstRating != null ? !worstRating.equals(that.worstRating) : that.worstRating != null);

    }

    @Override
    public int hashCode() {
        int result = bestRating != null ? bestRating.hashCode() : 0;
        result = 31 * result + (ratingValue != null ? ratingValue.hashCode() : 0);
        result = 31 * result + (worstRating != null ? worstRating.hashCode() : 0);
        result = 31 * result + (ratingCount != null ? ratingCount.hashCode() : 0);
        result = 31 * result + (reviewCount != null ? reviewCount.hashCode() : 0);
        return result;
    }
}
