package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

public class AggregateRatingBuilder {
    private String bestRating;
    private String ratingValue;
    private String worstRating;
    private String ratingCount;
    private String reviewCount;
    private String sourceUrl;

    public AggregateRatingBuilder setBestRating(final String bestRating) {
        this.bestRating = bestRating;
        return this;
    }

    public AggregateRatingBuilder setRatingValue(final String ratingValue) {
        this.ratingValue = ratingValue;
        return this;
    }

    public AggregateRatingBuilder setWorstRating(final String worstRating) {
        this.worstRating = worstRating;
        return this;
    }

    public AggregateRatingBuilder setRatingCount(final String ratingCount) {
        this.ratingCount = ratingCount;
        return this;
    }

    public AggregateRatingBuilder setReviewCount(final String reviewCount) {
        this.reviewCount = reviewCount;
        return this;
    }

    public AggregateRatingBuilder setSourceUrl(final String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    public AggregateRating createAggregateRating() {
        return new AggregateRating(bestRating, ratingValue, worstRating, ratingCount, reviewCount, sourceUrl);
    }
}