package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.xml.Xmler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import static ru.yandex.common.util.StringUtils.isEmpty;
import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 15.08.13
 * Time: 3:29
 */
public class Chords extends AbstractStructData {

    private static final Set<String> ACCORDS_TAGS = Cf.set("accords");

    private final String title;
    private final String artistName;
    private final List<Pair<String, String>> chordsAndTextLines;
    private final String raw;

    public Chords(final String title, final String artistName, final List<Pair<String, String>> chordsAndTextLines, final String raw, final String sourceUrl, final String lang) {
        super(sourceUrl, lang);
        this.title = title;
        this.artistName = artistName;
        this.chordsAndTextLines = chordsAndTextLines;
        this.raw = raw;
    }

    @Override
    public Set<String> getEntityTags() {
        return ACCORDS_TAGS;
    }

    @Override
    public Xmler.Tag toXml() {
        final List<Xmler.Tag> result = new ArrayList<Xmler.Tag>();
        result.add(getSourceUrlTag());
        appendIfNotNull(result,"song_name", title);
        appendIfNotNull(result,"artist_name", artistName);
        if (!isEmpty(raw)) {
            result.add(tag("raw", raw));
        }
        final List<Xmler.Tag> chords = new ArrayList<Xmler.Tag>();
        for (final Pair<String, String> r : chordsAndTextLines) {
            if (r.first != null) {
                chords.add(tag("chords", r.first));
            }
            if (r.second != null) {
                chords.add(tag("text", r.second));
            }
        }
        if (!chords.isEmpty()) {
            result.add(tag("CHORDS_TABS_TEXT", chords));
        }

        return tag("chords",attribute("type-id","23"), result);
    }
}