package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import org.jetbrains.annotations.Nullable;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import static ru.yandex.common.util.xml.Xmler.attribute;

/**
 * Created with IntelliJ IDEA.
 * User: slewa
 * Date: 03.04.13
 * Time: 13:11
 */
public class CreativeWork extends AbstractStructData {

//    description name author creator dateCreated datePublished genre headline inLanguage text

    private final List<String> description;
    private final String name;
    private final List<String> author;
    private final List<String> genre;
    private final String headline;
    private final String mainType;


    public CreativeWork(@Nullable String sourceUrl, @Nullable String lang, List<String> description, String name, List<String> author, List<String> genre, String headline,  String mainType) {
        super(sourceUrl, lang);
        this.description = description;
        this.name = name;
        this.author = author;
        this.genre = genre;
        this.headline = headline;
        this.mainType = mainType;
    }

    @Override
    public Set<String> getEntityTags() {
        return Collections.unmodifiableSet(Cf.set("creative-work"));
    }

    @Override
    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        for (String s : author) {
            appendIfNotNull(tags, "author", s);
        }
        for (String d : description) {
            appendIfNotNull(tags, "description", d);
        }
        appendIfNotNull(tags, "name", name);
        for (String g : genre) {
            appendIfNotNull(tags, "genre", g);
        }
        appendIfNotNull(tags, "headline", headline);
        appendIfNotNull(tags,"mainType",mainType);
        appendIfNotNull(tags,"source-url",getSourceUrl());
        appendIfNotNull(tags,"lang",getLang());

        return Xmler.tag("creative-work", attribute("type-id", "25"), tags);
    }


    public static class CreativeWorkBuilder {

        private String sourceUrl;
        private String lang;
        private List<String> description;
        private String name;
        private List<String> author;
        private List<String> genre;
        private String headline;
        private String mainType;

        CreativeWork createCreativeWork() {
            return new CreativeWork(sourceUrl, lang, description, name, author, genre, headline, mainType);
        }

        public CreativeWorkBuilder setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public CreativeWorkBuilder setLang(String lang) {
            this.lang = lang;
            return this;
        }

        public CreativeWorkBuilder setDescription(List<String> description) {
            this.description = description;
            return this;
        }

        public CreativeWorkBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public CreativeWorkBuilder setAuthor(List<String> author) {
            this.author = author;
            return this;
        }

        public CreativeWorkBuilder setGenre(List<String> genre) {
            this.genre = genre;
            return this;
        }

        public CreativeWorkBuilder setHeadline(String headline) {
            this.headline = headline;
            return this;
        }

        public CreativeWorkBuilder setMainType(String mainType) {
            this.mainType = mainType;
            return this;
        }
    }
}
