package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/8/11
 * Time: 5:49 PM
 * To change this template use File | Settings | File Templates.
 */
public class Geo {

    private final String latitude;
    private final String longitude;

    public Geo(final String latitude, final String longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public String getLongitude() {
        return longitude;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Geo geo = (Geo) o;

        if (latitude != null ? !latitude.equals(geo.latitude) : geo.latitude != null) {
            return false;
        }
        return !(longitude != null ? !longitude.equals(geo.longitude) : geo.longitude != null);

    }

    @Override
    public int hashCode() {
        int result = latitude != null ? latitude.hashCode() : 0;
        result = 31 * result + (longitude != null ? longitude.hashCode() : 0);
        return result;
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (latitude != null) {
            tags.add(tag("latitude", latitude));
        }
        if (longitude != null) {
            tags.add(tag("longitude", longitude));
        }
        return tag("geo", tags);
    }
}
