package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/17/11
 * Time: 1:06 AM
 * To change this template use File | Settings | File Templates.
 */
public class Ingredient {

    private final String name;
    private final String type;
    private final String value;
    private final String amount;

    public Ingredient(final String name, final String type, final String value, final String amount) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.amount = amount;
    }

    public String getName() {
        return name;
    }

    public String getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public String getAmount() {
        return amount;
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (name!=null)
            tags.add(tag("name",name));
        if (value!=null)
            tags.add(tag("value",value));
        if (type!=null)
            tags.add(tag("type",type));
        if (amount!=null)
            tags.add(tag("amount",amount));
        return tag("ingredient",tags);
    }
}
