package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.TextMicrodata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 3/13/12
 * Time: 2:30 AM
 */
public class Movie extends AbstractStructData {

    public final String name;
    public final List<String> description;
    public final List<TextMicrodata> actors;
    public final TextMicrodata director;
    public final String duration;
    public final TextMicrodata musicBy;
    public final TextMicrodata producer;
    public final TextMicrodata productionCompany;
    public final String trailer;
    public final String alternativeHeadline;
    public final List<TextMicrodata> awards;
    public final TextMicrodata contentRating;
    public final String dateCreated;
    public final String dateModified;
    public final String datePublished;
    public final List<TextMicrodata> genres;
    public final TextMicrodata inLanguage;
    public final TextMicrodata isFamilyFriendly;
    public final TextMicrodata version;

    public Movie(final String name, final List<String> description, final List<TextMicrodata> actors, final TextMicrodata director, final String duration, final TextMicrodata musicBy, final TextMicrodata producer, final TextMicrodata productionCompany, final String trailer, final String sourceUrl, final String alternativeHeadline, final List<TextMicrodata> awards, final TextMicrodata contentRating, final String dateCreated, final String dateModified, final String datePublished, final List<TextMicrodata> genre, final TextMicrodata inLanguage, final TextMicrodata familyFriendly, final TextMicrodata version, final String lang) {
        super(sourceUrl, lang);
        this.name = name;
        this.description = description;
        this.actors = actors;
        this.director = director;
        this.duration = duration;
        this.musicBy = musicBy;
        this.producer = producer;
        this.productionCompany = productionCompany;
        this.trailer = trailer;
        this.alternativeHeadline = alternativeHeadline;
        this.awards = awards;
        this.contentRating = contentRating;
        this.dateCreated = dateCreated;
        this.dateModified = dateModified;
        this.datePublished = datePublished;
        this.genres = genre;
        this.inLanguage = inLanguage;
        isFamilyFriendly = familyFriendly;
        this.version = version;
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();

        appendIfNotNull(tags, "name", name);
        for (final String desc : description) {
            appendIfNotNull(tags, "description", desc);
        }
        appendIfNotNull(tags, "director", director);
        appendIfNotNull(tags, "duration", duration);
        appendIfNotNull(tags, "music-by", musicBy);
        appendIfNotNull(tags, "producer", producer);
        appendIfNotNull(tags, "production-company", productionCompany);
        appendIfNotNull(tags, "trailer", trailer);
        for (final TextMicrodata actor : actors) {
            appendIfNotNull(tags, "actor", actor);
        }
        appendIfNotNull(tags, getSourceUrlTag());
        appendIfNotNull(tags, "alternative-headline", alternativeHeadline);
        appendIfNotNull(tags, "content-rating", contentRating);
        appendIfNotNull(tags, "date-created", dateCreated);
        appendIfNotNull(tags, "date-modified", dateModified);
        appendIfNotNull(tags, "date-published", datePublished);

        for (final TextMicrodata genre : genres) {
            appendIfNotNull(tags, "genre", genre);
        }

        appendIfNotNull(tags, "in-language", inLanguage);
        appendIfNotNull(tags, "is-family-friendly", isFamilyFriendly);

        appendIfNotNull(tags, "version", version);
        for (final TextMicrodata award : awards) {
            append(tags, award.toXml("award"));
        }
        appendIfNotNull(tags, getLangTag());
        return tag("movie", attribute("type-id", "22"), tags);
    }

    private Set<String> TAGS = Collections.unmodifiableSet(Cf.set("movie"));

    @Override
    public Set<String> getEntityTags() {
        return TAGS;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Movie movie = (Movie) o;

        if (actors != null ? !actors.equals(movie.actors) : movie.actors != null) {
            return false;
        }
        if (alternativeHeadline != null ? !alternativeHeadline.equals(movie.alternativeHeadline) :
                movie.alternativeHeadline != null) {
            return false;
        }
        if (awards != null ? !awards.equals(movie.awards) : movie.awards != null) {
            return false;
        }
        if (contentRating != null ? !contentRating.equals(movie.contentRating) : movie.contentRating != null) {
            return false;
        }
        if (dateCreated != null ? !dateCreated.equals(movie.dateCreated) : movie.dateCreated != null) {
            return false;
        }
        if (dateModified != null ? !dateModified.equals(movie.dateModified) : movie.dateModified != null) {
            return false;
        }
        if (datePublished != null ? !datePublished.equals(movie.datePublished) : movie.datePublished != null) {
            return false;
        }
        if (description != null ? !description.equals(movie.description) : movie.description != null) {
            return false;
        }
        if (director != null ? !director.equals(movie.director) : movie.director != null) {
            return false;
        }
        if (duration != null ? !duration.equals(movie.duration) : movie.duration != null) {
            return false;
        }
        if (genres != null ? !genres.equals(movie.genres) : movie.genres != null) {
            return false;
        }
        if (inLanguage != null ? !inLanguage.equals(movie.inLanguage) : movie.inLanguage != null) {
            return false;
        }
        if (isFamilyFriendly != null ? !isFamilyFriendly.equals(movie.isFamilyFriendly) :
                movie.isFamilyFriendly != null) {
            return false;
        }
        if (musicBy != null ? !musicBy.equals(movie.musicBy) : movie.musicBy != null) {
            return false;
        }
        if (name != null ? !name.equals(movie.name) : movie.name != null) {
            return false;
        }
        if (producer != null ? !producer.equals(movie.producer) : movie.producer != null) {
            return false;
        }
        if (productionCompany != null ? !productionCompany.equals(movie.productionCompany) :
                movie.productionCompany != null) {
            return false;
        }
        if (getSourceUrl() != null ? !getSourceUrl().equals(movie.getSourceUrl()) : movie.getSourceUrl() != null) {
            return false;
        }
        if (trailer != null ? !trailer.equals(movie.trailer) : movie.trailer != null) {
            return false;
        }
        return !(version != null ? !version.equals(movie.version) : movie.version != null);

    }
}
