package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.TextMicrodata;

import java.util.List;

import static ru.yandex.common.util.StringUtils.isEmpty;

public class MovieBuilder {
    private String name;
    private List<String> description;
    private List<TextMicrodata> actors;
    private TextMicrodata director;
    private String duration;
    private TextMicrodata musicBy;
    private TextMicrodata producer;
    private TextMicrodata productionCompany;
    private String trailer;
    private String sourceUrl;
    private String alternativeHeadline;
    private List<TextMicrodata> awards;
    private TextMicrodata contentRating;
    private String dateCreated;
    private String dateModified;
    private String datePublished;
    private List<TextMicrodata> genre;
    private TextMicrodata inLanguage;
    private TextMicrodata familyFriendly;
    private TextMicrodata version;
    private String lang;

    public MovieBuilder setName(final String name) {
        this.name = name;
        return this;
    }

    public MovieBuilder setDescription(final List<String> description) {
        this.description = description;
        return this;
    }

    public MovieBuilder setActors(final List<TextMicrodata> actors) {
        this.actors = actors;
        return this;
    }

    public MovieBuilder setDirector(final TextMicrodata director) {
        this.director = director;
        return this;
    }

    public MovieBuilder setDuration(final String duration) {
        this.duration = duration;
        return this;
    }

    public MovieBuilder setMusicBy(final TextMicrodata musicBy) {
        this.musicBy = musicBy;
        return this;
    }

    public MovieBuilder setProducer(final TextMicrodata producer) {
        this.producer = producer;
        return this;
    }

    public MovieBuilder setProductionCompany(final TextMicrodata productionCompany) {
        this.productionCompany = productionCompany;
        return this;
    }

    public MovieBuilder setTrailer(final String trailer) {
        this.trailer = trailer;
        return this;
    }

    public MovieBuilder setSourceUrl(final String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    public MovieBuilder setAlternativeHeadline(final String alternativeHeadline) {
        this.alternativeHeadline = alternativeHeadline;
        return this;
    }

    public MovieBuilder setAwards(final List<TextMicrodata> awards) {
        this.awards = awards;
        return this;
    }

    public MovieBuilder setContentRating(final TextMicrodata contentRating) {
        this.contentRating = contentRating;
        return this;
    }

    public MovieBuilder setDateCreated(final String dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MovieBuilder setDateModified(final String dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    public MovieBuilder setDatePublished(final String datePublished) {
        this.datePublished = datePublished;
        return this;
    }

    public MovieBuilder setGenre(final List<TextMicrodata> genre) {
        this.genre = genre;
        return this;
    }

    public MovieBuilder setInLanguage(final TextMicrodata inLanguage) {
        this.inLanguage = inLanguage;
        return this;
    }

    public MovieBuilder setFamilyFriendly(final TextMicrodata familyFriendly) {
        this.familyFriendly = familyFriendly;
        return this;
    }

    public MovieBuilder setVersion(final TextMicrodata version) {
        this.version = version;
        return this;
    }

    public MovieBuilder setLang(final String lang) {
        this.lang = lang;
        return this;
    }

    public Movie createMovie() {
        if (isEmpty(name)) {
            return null;
        }
        return new Movie(name, description, actors, director, duration, musicBy, producer, productionCompany, trailer,
                sourceUrl, alternativeHeadline, awards, contentRating, dateCreated, dateModified, datePublished, genre,
                inLanguage, familyFriendly, version, lang);
    }
}