package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/28/11
 * Time: 9:33 AM
 */
public class MusicGroup extends XmlStructData {

    public final String name;
    public final String image;
    public final String playCount;
    public final List<MusicRecording> recordings;
    public final String sourceUrl;

    public MusicGroup(final String name, final String image, final String playCount, final List<MusicRecording> recordings, final String sourceUrl) {
        this.name = name;
        this.image = image;
        this.playCount = playCount;
        this.sourceUrl = sourceUrl;
        this.recordings = Collections.unmodifiableList(recordings);
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (name != null) {
            tags.add(tag("name", name));
        }
        if (image != null) {
            tags.add(tag("image", image));
        }
        if (playCount != null) {
            tags.add(tag("playcount", playCount));
        }
        for (final MusicRecording recording : recordings) {
            tags.add(recording.toXml());
        }
        tags.add(tag("source-url", sourceUrl));
        return tag("musicgroup", attribute("type-id", "19"), tags);
    }

    private Set<String> TAGS = Collections.unmodifiableSet(Cf.set("address"));

    @Override
    public Set<String> getEntityTags() {
        return TAGS;
    }
}
