package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/28/11
 * Time: 9:33 AM
 */
public class MusicRecording {

    public final String name;
    public final String duration;
    public final String inAlbum;
    public final String url;
    public final String playCount;

    public MusicRecording(final String name, final String duration, final String inAlbum, final String url, final String playCount) {
        this.name = name;
        this.duration = duration;
        this.inAlbum = inAlbum;
        this.url = url;
        this.playCount = playCount;
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (name != null) {
            tags.add(tag("name", name));
        }
        if (url != null) {
            tags.add(tag("url", url));
        }
        if (inAlbum != null) {
            tags.add(tag("inalbum", inAlbum));
        }
        if (duration != null) {
            tags.add(tag("duration", duration));
        }
        if (playCount != null) {
            tags.add(tag("playcount", playCount));
        }
        return tag("musicrecording", tags);
    }
}
