package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/8/11
 * Time: 5:47 PM
 * To change this template use File | Settings | File Templates.
 */
public class Phone {

    private final String phone;
    private final String type;

    public Phone(final String type, final String phone) {
        this.type = type;
        this.phone = phone;
    }

    public String getPhone() {
        return phone;
    }

    public String getType() {
        return type;
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append(type).append(":").append(phone);
        return sb.toString();
    }

    public Xmler.Tag toXml() {
        if(phone == null) return null;
        if (type!=null)
            return tag("tel",tag("type",type),tag("value",phone));
        else
            return tag("tel",tag("value",phone));
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Phone phone1 = (Phone) o;

        if (phone != null ? !phone.equals(phone1.phone) : phone1.phone != null) {
            return false;
        }
        return !(type != null ? !type.equals(phone1.type) : phone1.type != null);

    }

    @Override
    public int hashCode() {
        int result = phone != null ? phone.hashCode() : 0;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        return result;
    }
}
