package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

public class Product {

    private final List<String> categories;
    private final List<String> photos;
    private final String url;
    private final String brand;
    private final String name;
    private final List<Xmler.Tag> identifiers;

    //not implemented to output
    private final String price;
    private final String description;

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new ArrayList<Xmler.Tag>();
        if (categories != null) {
            for (final String category : categories) {
                tags.add(tag("category", category));
            }
        }
        if (photos != null) {
            for (final String photo : photos) {
                tags.add(tag("photo", photo));
            }
        }
        if (url != null) {
            tags.add(tag("url", url));
        }
        if (brand != null) {
            tags.add(tag("brand", brand));
        }
        if (name != null) {
            tags.add(tag("name", name));
        }
        if (identifiers != null) {
            for (final Xmler.Tag identifier : identifiers) {
                tags.add(identifier);
            }
        }
        return tag("hproduct", tags);
    }

    public Product(final List<String> categories, final List<String> photos, final String url, final String brand, final String name, final List<Xmler.Tag> identifiers, final String price, final String description) {
        this.categories = categories;
        this.photos = photos;
        this.url = url;
        this.brand = brand;
        this.name = name;
        this.identifiers = identifiers;
        this.price = price;
        this.description = description;
    }

    public List<String> getCategories() {
        return categories;
    }

    public List<String> getPhotos() {
        return photos;
    }

    public String getUrl() {
        return url;
    }

    public String getBrand() {
        return brand;
    }

    public String getName() {
        return name;
    }

    public List<Xmler.Tag> getIdentifiers() {
        return identifiers;
    }

    public String getPrice() {
        return price;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Product)) return false;

        final Product product = (Product) o;

        if (brand != null ? !brand.equals(product.brand) : product.brand != null) return false;
        if (categories != null ? !categories.equals(product.categories) : product.categories != null) return false;
        if (description != null ? !description.equals(product.description) : product.description != null) return false;
        if (identifiers != null ? !identifiers.equals(product.identifiers) : product.identifiers != null) return false;
        if (name != null ? !name.equals(product.name) : product.name != null) return false;
        if (photos != null ? !photos.equals(product.photos) : product.photos != null) return false;
        if (price != null ? !price.equals(product.price) : product.price != null) return false;
        return !(url != null ? !url.equals(product.url) : product.url != null);

    }

    @Override
    public int hashCode() {
        int result = categories != null ? categories.hashCode() : 0;
        result = 31 * result + (photos != null ? photos.hashCode() : 0);
        result = 31 * result + (url != null ? url.hashCode() : 0);
        result = 31 * result + (brand != null ? brand.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (identifiers != null ? identifiers.hashCode() : 0);
        result = 31 * result + (price != null ? price.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        return result;
    }
}
