package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.xml.Xmler;

import java.util.ArrayList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

public class Rating {

    private final String value;
    private final String worst;
    private final String best;
    private final String name;

    //not implemented to output
    private final String average;
    private final List<String> tags;

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new ArrayList<Xmler.Tag>();
        if (value != null) {
            tags.add(tag("value", value));
        }
        if (worst != null) {
            tags.add(tag("worst", worst));
        }
        if (best != null) {
            tags.add(tag("best", best));
        }
        if (name != null) {
            tags.add(tag("name", name));
        }
        return tag("rating", tags);
    }

    public Rating(final String value, final String worst, final String best, final String name, final String average, final List<String> tags) {
        this.value = value;
        this.worst = worst;
        this.best = best;
        this.name = name;
        this.average = average;
        this.tags = tags;
    }

    public String getValue() {
        return value;
    }

    public String getWorst() {
        return worst;
    }

    public String getBest() {
        return best;
    }

    public String getAverage() {
        return average;
    }

    public List<String> getTags() {
        return tags;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Rating rating = (Rating) o;

        if (average != null ? !average.equals(rating.average) : rating.average != null) {
            return false;
        }
        if (best != null ? !best.equals(rating.best) : rating.best != null) {
            return false;
        }
        if (name != null ? !name.equals(rating.name) : rating.name != null) {
            return false;
        }
        if (tags != null ? !tags.equals(rating.tags) : rating.tags != null) {
            return false;
        }
        if (value != null ? !value.equals(rating.value) : rating.value != null) {
            return false;
        }
        return !(worst != null ? !worst.equals(rating.worst) : rating.worst != null);

    }

    @Override
    public int hashCode() {
        int result = value != null ? value.hashCode() : 0;
        result = 31 * result + (worst != null ? worst.hashCode() : 0);
        result = 31 * result + (best != null ? best.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (average != null ? average.hashCode() : 0);
        result = 31 * result + (tags != null ? tags.hashCode() : 0);
        return result;
    }
}
