package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Either;
import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 8/17/11
 * Time: 1:05 AM
 * To change this template use File | Settings | File Templates.
 */
public class Recipe {

    private final String fn;
    private final List<Xmler.Tag> ingredients;
    private final String category;
    private final List<String> instructions;
    private final String yield;
    private final String duration;
    private final List<String> photos;
    private final String result_photo;
    private final List<Either<Xmler.Tag, String>> authors;
    private final List<Xmler.Tag> nutrition;
    private final String sub_category;
    private final String cuisine_type;
    private final String weight;
    private final String sourceUrl;


    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        tags.add(tag("name",fn));
        if (sourceUrl != null)
            tags.add(tag("source-url", sourceUrl));
        if (ingredients != null) {
            for (final Xmler.Tag ingredient : ingredients) {
                tags.add(ingredient);
            }
        }
        if (category != null) {
            tags.add(tag("category", category));
        }
        if (instructions != null) {
            for (final String instruction : instructions) {
                tags.add(tag("instruction", instruction));
            }
        }
        if (yield != null)
            tags.add(tag("yield", yield));
        if (duration != null)
            tags.add(tag("duration", duration));
        if (photos != null) {
            for (final String photo : photos)
                tags.add(tag("photo", photo));
        }
        if (result_photo != null)
            tags.add(tag("result-photo", result_photo));
        if (authors != null) {
            for (final Either<Xmler.Tag, String> author : authors) {
                if (author.isLeftNotRight()) {
                    tags.add(author.asLeft());
                } else {
                    tags.add(tag("author", author.asRight()));
                }
            }
        }
        if(nutrition != null) {
            tags.add(tag("nutrition",nutrition));
        }
        if (sub_category != null)
            tags.add(tag("sub-category", sub_category));
        if (cuisine_type != null)
            tags.add(tag("cuisine-type", cuisine_type));
        if (weight != null)
            tags.add(tag("weight", weight));
        return tag("hrecipe", attribute("type-id", "1"), tags);
    }

    public Recipe(final String fn, final List<Xmler.Tag> ingredients, final String category, final List<String> instructions, final String yield, final String duration, final List<String> photos, final String result_photo, final List<Either<Xmler.Tag, String>> authors, final List<Xmler.Tag> nutrition, final String sub_category, final String cuisine_type, final String weight, final String sourceUrl) {
        this.fn = fn;
        this.ingredients = ingredients;
        this.category = category;
        this.instructions = instructions;
        this.yield = yield;
        this.duration = duration;
        this.photos = photos;
        this.result_photo = result_photo;
        this.authors = authors;
        this.nutrition = nutrition;
        this.sub_category = sub_category;
        this.cuisine_type = cuisine_type;
        this.weight = weight;
        this.sourceUrl = sourceUrl;
    }

    public String getFn() {
        return fn;
    }

    public List<Xmler.Tag> getIngredients() {
        return ingredients;
    }

    public String getCategory() {
        return category;
    }

    public List<String> getInstructions() {
        return instructions;
    }

    public String getYield() {
        return yield;
    }

    public String getDuration() {
        return duration;
    }

    public List<String> getPhotos() {
        return photos;
    }

    public String getResult_photo() {
        return result_photo;
    }

    public List<Either<Xmler.Tag, String>> getAuthors() {
        return authors;
    }

    public List<Xmler.Tag> getNutrition() {
        return nutrition;
    }

    public String getSub_category() {
        return sub_category;
    }

    public String getCuisine_type() {
        return cuisine_type;
    }

    public String getWeight() {
        return weight;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Recipe)) return false;

        final Recipe recipe = (Recipe) o;

        if (authors != null ? !authors.equals(recipe.authors) : recipe.authors != null) return false;
        if (category != null ? !category.equals(recipe.category) : recipe.category != null) return false;
        if (cuisine_type != null ? !cuisine_type.equals(recipe.cuisine_type) : recipe.cuisine_type != null)
            return false;
        if (duration != null ? !duration.equals(recipe.duration) : recipe.duration != null) return false;
        if (fn != null ? !fn.equals(recipe.fn) : recipe.fn != null) return false;
        if (ingredients != null ? !ingredients.equals(recipe.ingredients) : recipe.ingredients != null) return false;
        if (instructions != null ? !instructions.equals(recipe.instructions) : recipe.instructions != null)
            return false;
        if (nutrition != null ? !nutrition.equals(recipe.nutrition) : recipe.nutrition != null) return false;
        if (photos != null ? !photos.equals(recipe.photos) : recipe.photos != null) return false;
        if (result_photo != null ? !result_photo.equals(recipe.result_photo) : recipe.result_photo != null)
            return false;
        if (sub_category != null ? !sub_category.equals(recipe.sub_category) : recipe.sub_category != null)
            return false;
        if (weight != null ? !weight.equals(recipe.weight) : recipe.weight != null) return false;
        return !(yield != null ? !yield.equals(recipe.yield) : recipe.yield != null);

    }

    @Override
    public int hashCode() {
        int result = fn != null ? fn.hashCode() : 0;
        result = 31 * result + (ingredients != null ? ingredients.hashCode() : 0);
        result = 31 * result + (category != null ? category.hashCode() : 0);
        result = 31 * result + (instructions != null ? instructions.hashCode() : 0);
        result = 31 * result + (yield != null ? yield.hashCode() : 0);
        result = 31 * result + (duration != null ? duration.hashCode() : 0);
        result = 31 * result + (photos != null ? photos.hashCode() : 0);
        result = 31 * result + (result_photo != null ? result_photo.hashCode() : 0);
        result = 31 * result + (authors != null ? authors.hashCode() : 0);
        result = 31 * result + (nutrition != null ? nutrition.hashCode() : 0);
        result = 31 * result + (sub_category != null ? sub_category.hashCode() : 0);
        result = 31 * result + (cuisine_type != null ? cuisine_type.hashCode() : 0);
        result = 31 * result + (weight != null ? weight.hashCode() : 0);
        return result;
    }
}
