package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Either;
import ru.yandex.common.util.xml.Xmler;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.HProduct;
import ru.yandex.webmaster3.core.semantic.review_business.model.Author;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.tag;

public class Review {

    private final List<String> summaries;
    private final List<String> descriptions;
    private final List<String> pros;
    private final List<String> contras;
    private final String dtreviewed;
    private final List<Rating> ratings;
    private final String permalink;
    private final List<Author> reviewers;
    private final List<String> types;
    private final Either<List<HProduct>, Organization> items;
    private final String owningTime;
    private final List<String> reviewsurls;
    private final List<Rating> tag;

    //not implemented to output
    private final List<String> photos;
    private final List<String> tags;
    private final List<String> bookmarks;
    private final String license;

    private final String sourceUrl;

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new ArrayList<Xmler.Tag>();
        if (sourceUrl != null) {
            tags.add(tag("source-url", sourceUrl));
        }
        if (summaries != null) {
            for (final String summary : summaries) {
                tags.add(tag("summary", summary));
            }
        }
        if (descriptions != null) {
            for (final String description : descriptions) {
                tags.add(tag("description", description));
            }
        }
        if (pros != null) {
            for (final String pro : pros) {
                tags.add(tag("pro", pro));
            }
        }
        if (contras != null) {
            for (final String contra : contras) {
                tags.add(tag("contra", contra));
            }
        }
        if (dtreviewed != null) {
            tags.add(tag("dtreviewed", dtreviewed));
        }
        if (ratings != null) {
            for (final Rating rating : ratings) {
                tags.add(rating.toXml());
            }
        }
        if (permalink != null) {
            tags.add(tag("permalink", permalink));
        }
        if (reviewers != null) {
            for (final Author reviewer : reviewers) {
                final List<Xmler.Tag> fields = new LinkedList<Xmler.Tag>();
                if (reviewer.getFn() != null) {
                    fields.add(tag("fn", reviewer.getFn()));
                }
                if (reviewer.getUrl() != null) {
                    fields.add(tag("url", reviewer.getUrl()));
                }
                tags.add(tag("reviewer", fields));
            }
        }
        if (types != null) {
            for (final String type : types) {
                tags.add(tag("type", type));
            }
        }
        if (items != null) {
            if (items.isLeftNotRight()) {
                for (final HProduct item : items.asLeft()) {
                    tags.add(tag("product", item.toString()));
                }
            } else {
                tags.add(items.asRight().toXml());
            }
        }

        for (final Rating r : tag) {
            tags.add(r.toXml());
        }

        if (owningTime != null) {
            tags.add(tag("owning-time", owningTime));
        }
        if (reviewsurls != null) {
            for (final String reviewsurl : reviewsurls) {
                tags.add(tag("reviewsurl", reviewsurl));
            }
        }
        return tag("hreview", tags);
    }

    public Review(final List<String> summaries, final List<String> descriptions, final List<String> pros, final List<String> contras, final String dtreviewed, final List<Rating> ratings, final String permalink, final List<Author> reviewers, final List<String> types, final Either<List<HProduct>, Organization> items, final String owningTime, final List<String> reviewsurls, final List<Rating> tag, final List<String> photos, final List<String> tags, final List<String> bookmarks, final String license, final String sourceUrl) {
        this.summaries = summaries;
        this.descriptions = descriptions;
        this.pros = pros;
        this.contras = contras;
        this.dtreviewed = dtreviewed;
        this.ratings = ratings;
        this.permalink = permalink;
        this.reviewers = reviewers;
        this.types = types;
        this.items = items;
        this.owningTime = owningTime;
        this.reviewsurls = reviewsurls;
        this.tag = tag;
        this.photos = photos;
        this.tags = tags;
        this.bookmarks = bookmarks;
        this.license = license;
        this.sourceUrl = sourceUrl;
    }

    public List<String> getSummaries() {
        return summaries;
    }

    public List<String> getDescriptions() {
        return descriptions;
    }

    public List<String> getPros() {
        return pros;
    }

    public List<String> getContras() {
        return contras;
    }

    public String getDtreviewed() {
        return dtreviewed;
    }

    public List<Rating> getRatings() {
        return ratings;
    }

    public String getPermalink() {
        return permalink;
    }

    public List<Author> getReviewers() {
        return reviewers;
    }

    public List<String> getTypes() {
        return types;
    }

    public Either<List<HProduct>, Organization> getItems() {
        return items;
    }

    public String getOwningTime() {
        return owningTime;
    }

    public List<String> getReviewsurls() {
        return reviewsurls;
    }

    public List<String> getPhotos() {
        return photos;
    }

    public List<String> getTags() {
        return tags;
    }

    public List<String> getBookmarks() {
        return bookmarks;
    }

    public String getLicense() {
        return license;
    }

    public String getSourceUrl() {
        return sourceUrl;
    }

    public List<Rating> getTag() {
        return tag;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final Review review = (Review) o;

        if (bookmarks != null ? !bookmarks.equals(review.bookmarks) : review.bookmarks != null) {
            return false;
        }
        if (contras != null ? !contras.equals(review.contras) : review.contras != null) {
            return false;
        }
        if (descriptions != null ? !descriptions.equals(review.descriptions) : review.descriptions != null) {
            return false;
        }
        if (dtreviewed != null ? !dtreviewed.equals(review.dtreviewed) : review.dtreviewed != null) {
            return false;
        }
        if (items != null ? !items.equals(review.items) : review.items != null) {
            return false;
        }
        if (license != null ? !license.equals(review.license) : review.license != null) {
            return false;
        }
        if (owningTime != null ? !owningTime.equals(review.owningTime) : review.owningTime != null) {
            return false;
        }
        if (permalink != null ? !permalink.equals(review.permalink) : review.permalink != null) {
            return false;
        }
        if (photos != null ? !photos.equals(review.photos) : review.photos != null) {
            return false;
        }
        if (pros != null ? !pros.equals(review.pros) : review.pros != null) {
            return false;
        }
        if (ratings != null ? !ratings.equals(review.ratings) : review.ratings != null) {
            return false;
        }
        if (reviewers != null ? !reviewers.equals(review.reviewers) : review.reviewers != null) {
            return false;
        }
        if (reviewsurls != null ? !reviewsurls.equals(review.reviewsurls) : review.reviewsurls != null) {
            return false;
        }
        if (sourceUrl != null ? !sourceUrl.equals(review.sourceUrl) : review.sourceUrl != null) {
            return false;
        }
        if (summaries != null ? !summaries.equals(review.summaries) : review.summaries != null) {
            return false;
        }
        if (tag != null ? !tag.equals(review.tag) : review.tag != null) {
            return false;
        }
        if (tags != null ? !tags.equals(review.tags) : review.tags != null) {
            return false;
        }
        return !(types != null ? !types.equals(review.types) : review.types != null);

    }

    @Override
    public int hashCode() {
        int result = summaries != null ? summaries.hashCode() : 0;
        result = 31 * result + (descriptions != null ? descriptions.hashCode() : 0);
        result = 31 * result + (pros != null ? pros.hashCode() : 0);
        result = 31 * result + (contras != null ? contras.hashCode() : 0);
        result = 31 * result + (dtreviewed != null ? dtreviewed.hashCode() : 0);
        result = 31 * result + (ratings != null ? ratings.hashCode() : 0);
        result = 31 * result + (permalink != null ? permalink.hashCode() : 0);
        result = 31 * result + (reviewers != null ? reviewers.hashCode() : 0);
        result = 31 * result + (types != null ? types.hashCode() : 0);
        result = 31 * result + (items != null ? items.hashCode() : 0);
        result = 31 * result + (owningTime != null ? owningTime.hashCode() : 0);
        result = 31 * result + (reviewsurls != null ? reviewsurls.hashCode() : 0);
        result = 31 * result + (tag != null ? tag.hashCode() : 0);
        result = 31 * result + (photos != null ? photos.hashCode() : 0);
        result = 31 * result + (tags != null ? tags.hashCode() : 0);
        result = 31 * result + (bookmarks != null ? bookmarks.hashCode() : 0);
        result = 31 * result + (license != null ? license.hashCode() : 0);
        result = 31 * result + (sourceUrl != null ? sourceUrl.hashCode() : 0);
        return result;
    }
}
