package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Either;
import ru.yandex.webmaster3.core.semantic.review_business.auto.model.HProduct;
import ru.yandex.webmaster3.core.semantic.review_business.model.Author;

import java.util.List;

public class ReviewBuilder {
    private List<String> summaries;
    private List<String> descriptions;
    private List<String> pros;
    private List<String> contras;
    private String dtreviewed;
    private List<Rating> ratings;
    private String permalink;
    private List<Author> reviewers;
    private List<String> types;
    private Either<List<HProduct>, Organization> items;
    private String owningTime;
    private List<String> reviewsurls;
    private List<Rating> tag;
    private List<String> photos;
    private List<String> tags;
    private List<String> bookmarks;
    private String license;
    private String sourceUrl;

    public ReviewBuilder setSummaries(final List<String> summaries) {
        this.summaries = summaries;
        return this;
    }

    public ReviewBuilder setDescriptions(final List<String> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public ReviewBuilder setPros(final List<String> pros) {
        this.pros = pros;
        return this;
    }

    public ReviewBuilder setContras(final List<String> contras) {
        this.contras = contras;
        return this;
    }

    public ReviewBuilder setDtreviewed(final String dtreviewed) {
        this.dtreviewed = dtreviewed;
        return this;
    }

    public ReviewBuilder setRatings(final List<Rating> ratings) {
        this.ratings = ratings;
        return this;
    }

    public ReviewBuilder setPermalink(final String permalink) {
        this.permalink = permalink;
        return this;
    }

    public ReviewBuilder setReviewers(final List<Author> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public ReviewBuilder setTypes(final List<String> types) {
        this.types = types;
        return this;
    }

    public ReviewBuilder setItems(final Either<List<HProduct>, Organization> items) {
        this.items = items;
        return this;
    }

    public ReviewBuilder setOwningTime(final String owningTime) {
        this.owningTime = owningTime;
        return this;
    }

    public ReviewBuilder setReviewsurls(final List<String> reviewsurls) {
        this.reviewsurls = reviewsurls;
        return this;
    }

    public ReviewBuilder setTag(final List<Rating> tag) {
        this.tag = tag;
        return this;
    }

    public ReviewBuilder setPhotos(final List<String> photos) {
        this.photos = photos;
        return this;
    }

    public ReviewBuilder setTags(final List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ReviewBuilder setBookmarks(final List<String> bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }

    public ReviewBuilder setLicense(final String license) {
        this.license = license;
        return this;
    }

    public ReviewBuilder setSourceUrl(final String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    public Review createReview() {
        return new Review(summaries, descriptions, pros, contras, dtreviewed, ratings, permalink, reviewers, types,
                items, owningTime, reviewsurls, tag, photos, tags, bookmarks, license, sourceUrl);
    }
}