package ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.json.JsonConvertable;
import ru.yandex.common.util.json.JsonConvertableWithKey;
import ru.yandex.common.util.json.Jsonable;
import ru.yandex.common.util.json.Jsoner;
import ru.yandex.common.util.xml.Xmler;

import java.util.*;

import static ru.yandex.common.util.json.Jsoner.pair;
import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.tag;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 3/5/12
 * Time: 12:18 PM
 */
public class TermDef extends XmlStructData implements JsonConvertable, Jsonable {
    private final String term;
    private final List<String> definitions;
    private final String author;
    private final String source;
    private final String sourceDate;
    public final String sourceUrl;

    public TermDef(final String term, final List<String> definitions, final String author, final String source, final String sourceDate, final String sourceUrl) {
        this.term = term;
        this.sourceUrl = sourceUrl;
        this.definitions = definitions == null ? Collections.<String>emptyList() : definitions;
        this.author = author;
        this.source = source;
        this.sourceDate = sourceDate;
    }

    public Xmler.Tag toXml() {
        final List<Xmler.Tag> tags = new LinkedList<Xmler.Tag>();
        if (sourceUrl != null) {
            tags.add(tag("src",attribute("url",sourceUrl)));
        }
        if (term != null) {
            tags.add(tag("term", term));
        }
        if (author != null) {
            tags.add(tag("author", author));
        }
        if (source != null) {
            tags.add(tag("source", source));
        }
        if (sourceDate != null) {
            tags.add(tag("source-date", sourceDate));
        }
        for (final String defintition : definitions) {
            tags.add(tag("definition", defintition));
        }
        return tag("term-def", tags);
    }

    private Set<String> TAGS = Collections.unmodifiableSet(Cf.set("term-def"));

    @Override
    public Set<String> getEntityTags() {
        return TAGS;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final TermDef termDef = (TermDef) o;

        if (author != null ? !author.equals(termDef.author) : termDef.author != null) {
            return false;
        }
        if (definitions != null ? !definitions.equals(termDef.definitions) : termDef.definitions != null) {
            return false;
        }
        if (source != null ? !source.equals(termDef.source) : termDef.source != null) {
            return false;
        }
        if (sourceDate != null ? !sourceDate.equals(termDef.sourceDate) : termDef.sourceDate != null) {
            return false;
        }
        if (sourceUrl != null ? !sourceUrl.equals(termDef.sourceUrl) : termDef.sourceUrl != null) {
            return false;
        }
        return !(term != null ? !term.equals(termDef.term) : termDef.term != null);

    }

    @Override
    public int hashCode() {
        int result = term != null ? term.hashCode() : 0;
        result = 31 * result + (definitions != null ? definitions.hashCode() : 0);
        result = 31 * result + (author != null ? author.hashCode() : 0);
        result = 31 * result + (source != null ? source.hashCode() : 0);
        result = 31 * result + (sourceDate != null ? sourceDate.hashCode() : 0);
        result = 31 * result + (sourceUrl != null ? sourceUrl.hashCode() : 0);
        return result;
    }

    @Override
    public Jsoner.JsonObject asJson() {
        final List<JsonConvertableWithKey> result = new LinkedList<JsonConvertableWithKey>();
        result.add(pair("type","term-def"));
        if (term != null) {
            result.add(pair("title", term));
        }
        if (!definitions.isEmpty()) {
            final Jsoner.JsonArray categoriesArray = Jsoner.arrayOfSimples(definitions);
            result.add(pair("content", categoriesArray));
        }
        if (author != null) {
            result.add(pair("author", author));
        }
        if (source != null) {
            result.add(pair("source", source));
        }
        if (sourceDate != null) {
            result.add(pair("sourceDate", sourceDate));
        }
        return Jsoner.object(result);

    }

    @Override
    public void toJson(final StringBuilder storage) {
        asJson().toJson(storage);
    }
}
